;/*************************************************
; Program		:Generate PWM by Timer/Counter
; Description	:Timer/Counter1 generates pulse at PWM1 port  
; CPU Control	:ATmega163
; File name		:pwm1.asm
; Assembler		:AVR Studio 4.05
; 
;**************************************************
.include "m163def.inc"			

			.org   	$000 
    		rjmp  reset					;Reset Handle
;/************************
; Define Register
;/************************
.def		temp		= r19

;/*******************
; Main Program
;/*******************
reset:      ldi	temp,low(RAMEND)
            out	SPL,temp          	;init Stack Pointer     
            ldi	temp,high(RAMEND)
            out	SPH,temp        	

;/*************************************************
; Timer/Counter1 generates PWM at the PWM1 port
;/*************************************************
PWM1A:		ldi	temp,(1<<COM1A1)|(1<<PWM11)
			out	TCCR1A,temp			;9 bit PWM1 non-inverted (Fck/1022)
			ldi	temp,1<<CS11
			out	TCCR1B,temp			;CK/8
			ldi	temp,0
			out	OCR1AH,temp
			ldi	temp,0xCC			;duty cycle = 40% at frequency = 978Hz 
			out	OCR1AL,temp
			sbi	DDRD,PD5
Loop_PWM1A:	rjmp	Loop_PWM1A		
	
